/** @file   highscoresmenu.h
 * @brief   Declaraction of HighscoresMenu - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_HIGHSCORESMENU_H
#define H_WWW_HIGHSCORESMENU_H

#include "menupage.h"
#include "sprite.h"


namespace WeWantWar {


/** @class  HighscoresMenu
 * @brief   The VIEW HIGHSCORES - menu is an instance of this class.
 * @author  Tomi Lamminsaari
 *
 */
class HighscoresMenu : public MenuPage
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	HighscoresMenu();


	/** Destructor
   */
	virtual ~HighscoresMenu();

private:

	/** Copy constructor.
   * @param     rO                Reference to another HighscoresMenu
   */
  HighscoresMenu( const HighscoresMenu& rO );

	/** Assignment operator
   * @param     rO                Reference to another HighscoresMenu
   * @return    Reference to us.
   */
  HighscoresMenu& operator = ( const HighscoresMenu& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this menupage
   */
  virtual int update();
  
  /** Redraws this menupage
   */
  virtual void redraw();
  


  ///
  /// Getter methods
  /// ==============
  
  /** Returns the pageid
   * @return    MenuPage::HIGHSCORES
   */
  virtual MenuPage::PageID getPageID() const;


protected:

  /** Creates the graphics
   */
  void createGraphics();
  
  /** Draws the highscore entry to the given bitmap
   * @param     pB                Pointer to bitmap
   * @param     score             number of scores
   * @param     name              Name of the player
   */
  void drawEntry( BITMAP* pB, int score, const std::string& name );
  
  /** Cleans up the graphics
   */
  void cleanupGraphics();

  /** Updates the fadein state
   */
  virtual int updateFadeInState();
  
  /** Updates the visible state
   */
  virtual int updateVisibleState();
  
  /** Updates the fade out state
   */
  virtual int updateFadeOutState();
  


  ///
  /// Members
  /// =======

  /** Each highscore entry will be its own sprite. */
  std::vector<eng2d::Sprite*> m_sprites;



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: highscoresmenu.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:59+02  lamminsa
 * Initial revision
 *
 */
 
